/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY                          *
 *                                                                            *
 * This program is free software; you can redistribute it and/or modify       *
 * it under the terms of the GNU General Public Liense as published by        *
 * the Free Software Foundation, either version 2 of the License, or (at      * 
 * your option) any later version.                                            *
 *                                                                            *
 * The ITX package is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY, without even the implied warranty of MERCHANTABILITY *
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License   *
 * for more details.                                                          * 
 *                                                                            *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.                                                   *
 *                                                                            * 
 * Contact information:                                                       *
 * Donna Bergmark                                                             *
 * 484 Rhodes Hall                                                            *
 * Cornell University                                                         *
 * Ithaca, NY 14853-3801                                                      *
 * bergmark@cs.cornell.edu                                                    *
 ******************************************************************************/


package cnrg.itx.datax.client;

import cnrg.itx.datax.*;
import cnrg.itx.datax.devices.*;
import java.io.*;
import java.net.*;

/**
 * This class tests audio streaming over the network.  This sample routine uses a MicrophoneSource 
 * and a SpeakerDestination to stream audio to a NetworkClient.  Note that in creating 
 * the various destinations and sources, the remote source/destination sample size MUST equal the 
 * local source/destination sample size.
 * <p>
 * Usage: jview cnrg.itx.datax.devices.NetworkServer [client host name]
 * 
 * @author Jason Howes
 * @version 1.1, 3/6/1999
 * @see cnrg.itx.datax.Channel
 * @see cnrg.itx.datax.devices.StreamSource
 * @see cnrg.itx.datax.devices.NetworkDestination
 * @see cnrg.itx.datax.devices.NetworkSource
 * @see cnrg.itx.datax.devices.SpeakerDestination
 */
class NetworkServer
{	
	public static int NUM_ARGS	= 1;
		
	public static void main(String []args)
	{	
		try
		{	
			// Check command line args
			if (args.length != NetworkServer.NUM_ARGS)
			{
				System.out.println("NetworkClient : [client host name]");
				System.exit(0);
			}
			
			// NOTE: The local NetworkSource/Destination and remote Source/NetworkDestination sample
			// sizes MUST be the SAME!!!
			
			// Network properties
			PropertiesCollection outProperties = new PropertiesCollection();
			
			// Output channel, source, and destination
			Channel outChannel = new Channel();
			MicrophoneSource outSource = new MicrophoneSource(outChannel);
			NetworkDestination outDest = new NetworkDestination();
			
			// Set the network properties
			outProperties.addProperty(new NetworkProperty(NetworkClient.PORT,
														  InetAddress.getByName(args[0]),
														  SpeakerDestination.SAMPLE_SIZE,
														  0));
			outDest.setPeerProperties(outProperties);
			
			// Set output channel
			outChannel.setSource(outSource);
			outChannel.addDestination(outDest);
			
			// Start source channel
			outChannel.open();
			
			// Let the audio stream...
			System.out.println("Streaming audio to NetworkClient @ " + args[0]);
		}
		catch (Exception e)
		{
			System.out.println(e.getMessage());
		}
	}
}
